<?php
/* ====================
Copyright (c) 2008, Vladimir Sibirov.
All rights reserved. Distributed under BSD License.
[BEGIN_SED_EXTPLUGIN]
Code=reviews
Part=main
File=reviews
Hooks=standalone
Tags=reviews.tpl:{REVIEWS_PAGNAV},{REVIEWS_PAGE_PREV},{REVIEWS_PAGE_NEXT},{REVIEWS_TOP_CURRENCY},{REVIEWS_ROW_ID},{REVIEWS_ROW_DATE},{REVIEWS_ROW_RECOMMENDED},{REVIEWS_ROW_TEXT},{REVIEWS_ROW_PROS},{REVIEWS_ROW_CONS},{REVIEWS_ROW_PRICE},{REVIEWS_ROW_STARS},{REVIEWS_ROW_POSTERNAME},{REVIEWS_ROW_POSTERID},{REVIEWS_ROW_MAINGRPSTARS},{REVIEWS_ROW_MAINGRPICON},{REVIEWS_ROW_USERTEXT},{REVIEWS_ROW_AVATAR},{REVIEWS_ROW_GENDER},{REVIEWS_ROW_COUNTRY},{REVIEWS_ROW_COUNTRYFLAG},{REVIEWS_ROW_WEBSITE},{REVIEWS_ROW_WEBSITERAW},{REVIEWS_ROW_LOCATION},{REVIEWS_ROW_OCCUPATION},{REVIEWS_ROW_AGE},{REVIEWS_ROW_POSTCOUNT},{REVIEWS_ROW_XROW_TOP},{REVIEWS_ROW_XROW_XRATE},{REVIEWS_FORM_ACTION},{REVIEWS_FORM_RATING},{REVIEWS_FORM_TEXTBOXER},{REVIEWS_FORM_XROW_TOP},{REVIEWS_FORM_XROW_XRATE},{REVIEWS_BACK}
Order=10
[END_SED_EXTPLUGIN]
==================== */
if (!defined('SED_CODE')) { die('Wrong URL.'); }

$db_reviews = isset($db_reviews) ? $db_reviews : $db_x . 'reviews';

$tmp = preg_split('#\r?\n#', $cfg['plugin']['reviews']['rates']);
$xrates = array();
foreach ($tmp as $xr)
{
	if (trim($xr, "\r\n\t ") != '')
		$xrates[] = trim($xr, "\r\n\t ");
}

require_once sed_langfile('reviews');

$act = sed_import('act', 'G', 'ALP');
$id = sed_import('id', 'G', 'INT');
$upd = sed_import('upd', 'G', 'BOL');

if ($id > 0)
{
	if ($act == 'add')
	{
		$sql_keys = '';
		$sql_vals = '';
		$rtext = sed_sql_prep(sed_import('rtext', 'P', 'TXT'));
		$rpros = sed_sql_prep(sed_import('pros', 'P', 'STX'));
		$rcons = sed_sql_prep(sed_import('cons', 'P', 'STX'));
		$rprice = floatval(trim(str_replace(',', '.', sed_import('price', 'P', 'STX'))));
		$recomm = sed_import('recommend', 'P', 'BOL');
		$rating = sed_import('rating', 'P', 'INT');
		for ($i = 1; $i <= count($xrates); $i++)
		{
			$rxrate = sed_import("rate$i", 'P', 'INT');
			if ($rxrate < 1 || $rxrate > 10)
				$rxrate = 5;
			$sql_keys .= ", rw_rate$i";
			$sql_vals .= ", $rxrate";
		}
		if (empty($rtext) || empty($rating) || $rating < 1 || $rating > 10)
		{
			// ERR
		}
		else
		{
			$rdate = time();
			$rcm = $recomm ? 1 : 'NULL';
			sed_sql_query("INSERT INTO $db_reviews (rw_page, rw_user, rw_date, rw_recommend, rw_text, rw_pros, rw_cons, rw_price, rw_rating$sql_keys)
			VALUES ($id, {$usr['id']}, $rdate, $rcm, '$rtext', '$rpros', '$rcons', $rprice, $rating $sql_vals)");
		}
		sed_redirect(sed_url('page', "id=$id"));
		exit;
	}
	elseif ($act == 'del')
	{
		$rev = sed_sql_fetcharray(sed_sql_query("SELECT rw_user, rw_page FROM $db_reviews WHERE rw_id = $id"));
		if ($rev['rw_user'] == $usr['id'] || sed_auth('plug', 'reviews', 'A'))
		{
			sed_sql_query("DELETE FROM $db_reviews WHERE rw_id = $id");
		}
		sed_redirect(sed_url('page', "id=" . $rev['rw_page']));
		exit;
	}
	elseif ($act == 'edit')
	{
		$row = sed_sql_fetcharray(sed_sql_query("SELECT * FROM $db_reviews WHERE rw_id = $id"));
		if (empty($row) || ($row['rw_user'] != $usr['id'] && !sed_auth('plug', 'reviews', 'A')))
		{
			sed_die(); // ERR
		}
		if ($upd)
		{
			// Apply changes
			$sql_upd = '';
			$rtx = sed_import('rtext', 'P', 'TXT');
			$rtext = sed_sql_prep($rtx);
			$rpros = sed_sql_prep(sed_import('pros', 'P', 'STX'));
			$rcons = sed_sql_prep(sed_import('cons', 'P', 'STX'));
			$rprice = floatval(trim(str_replace(',', '.', sed_import('price', 'P', 'STX'))));
			$recomm = sed_import('recommend', 'P', 'BOL');
			$rating = sed_import('rating', 'P', 'INT');
			for ($i = 1; $i <= count($xrates); $i++)
			{
				$rxrate[$i] = sed_import("rate$i", 'P', 'INT');
				if ($rxrate[$i] < 1 || $rxrate[$i] > 10)
					$rxrate[$i] = 5;
				$sql_upd .= ", rw_rate$i = {$rxrate[$i]}";
			}
			if (empty($rtext) || empty($rating) || $rating < 1 || $rating > 10)
			{
				// ERR
			}
			else
			{
				$rcm = $recomm ? 1 : 'NULL';
				sed_sql_query("UPDATE $db_reviews SET rw_recommend = $rcm, rw_text = '$rtext', rw_pros = '$rpros', rw_cons = '$rcons', rw_price = $rprice, rw_rating = $rating $sql_upd WHERE rw_id = $id");
				$row['rw_text'] = $rtx;
				$row['rw_pros'] = $rpros;
				$row['rw_cons'] = $rcons;
				$row['rw_price'] = $rprice;
				$row['rw_recommend'] = $recomm;
				$row['rw_rating'] = $rating;
				for ($i = 1; $i <= count($xrates); $i++)
					$row["rw_rate$i"] = $rxrate[$i];
			}
		}
		$t = new XTemplate(sed_skinfile('reviews', true));
		for ($i = 0; $i < count($xrates); $i++)
		{
			$pag_selectbox = '';
			for ($j = 1; $j < 11; $j++)
				$pag_selectbox .= $j == $row['rw_rate' . ($i + 1)] ? '<option value="' . $j . '" selected="selected">' . $j . '</option>'
						: '<option value="' . $j . '">' . $j . '</option>';
			$t->assign(array(
				"REVIEWS_FORM_XROW_TOP" => $xrates[$i],
				"REVIEWS_FORM_XROW_XRATE" => '<select name="rate' . ($i + 1) . '">' . $pag_selectbox . '</select>'
			));
			$t->parse('MAIN.REVIEWS_FORM.REVIEWS_FORM_XROW');
		}
		// Review input form
		$pag_selectbox = '';
		for ($j = 1; $j < 11; $j++)
			$pag_selectbox .= $j == $row['rw_rating'] ? '<option value="' . $j . '" selected="selected">' . $j . '</option>' : '<option value="' . $j . '">' . $j . '</option>';
		if ($row['rw_recommend'])
		{
			$rec_y = 'selected="selected"';
			$rec_n = '';
		}
		else
		{
			$rec_y = '';
			$rec_n = 'selected="selected"';
		}
		$t->assign(array(
			'REVIEWS_TOP_CURRENCY' => $cfg['plugin']['reviews']['cur'],
			'REVIEWS_FORM_ACTION' => sed_url('plug', 'e=reviews&act=edit&upd=1&id=' . $id),
			'REVIEWS_FORM_RATING' => '<select name="rating">' . $pag_selectbox . '</select>',
			'REVIEWS_FORM_RECOMMEND' => '<select name="recommend"><option value="1" ' . $rec_y . '>' . $L['Yes'] . '</option><option value="0" ' . $rec_n . '>' . $L['No'] . '</option></select>',
			'REVIEWS_FORM_PRICE' => $row['rw_price'],
			'REVIEWS_FORM_PROS' => htmlspecialchars($row['rw_pros']),
			'REVIEWS_FORM_CONS' => htmlspecialchars($row['rw_cons']),
			'REVIEWS_FORM_TEXT' => '<textarea name="rtext" class="editor">' . htmlspecialchars($row['rw_text']) . '</textarea>',
			'REVIEWS_BACK' => '<a href="' . sed_url('page', 'id=' . $row['rw_page']) . '">' . $L['Back'] . '</a>'
		));
		$t->parse('MAIN.REVIEWS_FORM');

		if ($upd)
		{
			sed_redirect(sed_url('page', 'id=' . $row['rw_page']));
			exit;
		}
	}
	else
	{
		// Display as single review?
	}
}
else
{
	// Display review stats?
}

?>