<?php
/**
 * Functions
 *
 * @package imgsize
 * @version 1.0
 * @author Trustmaster
 * @copyright (c) 2010 Vladimir Sibirov
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL');

/**
 * PCRE replace callback for imgsize
 * @param array $m PCRE matches
 * @return string
 */
function imgsize_callback($m)
{
	$dims = getimagesize($m[1]);
	return '<img src="' . $m[1] . '" alt="' . $m[2] . '" ' . $dims[3] . ' />';
}

/**
 * Inserts width/height into img tags
 * @param string $text Post HTML
 * @return string
 */
function imgsize_post_process($text)
{
	return preg_replace_callback('`<img src="(.*?datas/users/.+?\.jpg)" alt="(.*?)" />`', 'imgsize_callback', $text);
}

?>
