<?PHP

/**
 * Spanish Language File for Admin Area (admin.lang.php)
 *
 * @package Cotonti
 * @version 0.1.0
 * @author Cotonti Translators Team
 * @copyright Copyright (c) Cotonti Team 2008-2009
 * @license BSD
 * Language: Spanish (code:es)
 * Localization done by : Orestes orestes.garcia@gmail.com  
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Config Section
 */

$L['core_comments'] = &$L['Comments'];
$L['core_forums'] = &$L['Forums'];
$L['core_lang'] = &$L['Language'];
$L['core_main'] = 'Parámetros principales';
$L['core_menus'] = &$L['Menus'];
$L['core_page'] = &$L['Pages'];
$L['core_parser'] = &$L['Parser'];
$L['core_pfs'] = &$L['PFS'];
$L['core_plug'] = &$L['Plugins'];
$L['core_pm'] = &$L['Private_Messages'];
$L['core_polls'] = &$L['Polls'];
$L['core_ratings'] = &$L['Ratings'];
$L['core_skin'] = &$L['Skins'];
$L['core_time'] = 'Time and Date';
$L['core_title'] = 'Titles (&lt;title&gt; tag)';
$L['core_trash'] = &$L['Trashcan'];
$L['core_users'] = &$L['Users'];

/**
 * Config Section
 * Comments Subsection
 */

$L['cfg_countcomments'] = array('Contar comentarios', 'Mostrar la suma de comentarios cerca del icono');
$L['cfg_disable_comments'] = array('Deshabilitar los comentarios', '');
$L['cfg_expand_comments'] = array('Expandir comentarioss', 'Mostrar los comentarios expandidos por defecto');
$L['cfg_maxcommentsperpage'] = array('Max. comentarios por página', ' ');   // New in N-0.0.6
$L['cfg_commentsize'] = array('Tamaño máximo de comentario', 'En bytes (cero para ilimitado). Defecto: 0');   // New in N-0.0.6

/**
 * Config Section
 * Forums Subsection
 */

$L['cfg_antibumpforums'] = array('Protección Anti-bump', 'Evita que los usuarios posteen dos veces seguidas en el mismo tema');	// New in N-0.1.0
$L['cfg_disable_forums'] = array('Deshabilitar los foros', '');
$L['cfg_hideprivateforums'] = array('Esconder los foros privados', '');
$L['cfg_hottopictrigger'] = array('Mensajes necesarios para que un tema esté \'hot\'', '');
$L['cfg_maxtopicsperpage'] = array('Mámimo de temas por página', '');
$L['cfg_mergeforumposts'] = array('Fusión de mensajes', 'Fusionará los mensajes de un usuario si los envía consecutivamente. El anti-bump debe estar deshabilitado');	// New in N-0.1.0
$L['cfg_mergetimeout'] = array('Tiempo de espera para fusión de mensaje', 'No fusionará los mensajes de un usuario si los envía consecutivamente después del tiempo de espera (en horas). La fusión de mensajes debe estar habilitada (cero para deshabilitar el tiempo de espera)');	// New in N-0.1.0
$L['cfg_maxpostsperpage'] = array('Máximos mensajes por página', ' '); // New in N-0.0.6

/**
 * Config Section
 * Lang Subsection
 */

$L['cfg_forcedefaultlang'] = array('Forzar el idioma por defecto para todos los usuarios', '');

/**
 * Config Section
 * Main Subsection
 */

$L['cfg_adminemail'] = array('E-mail del administrador', 'requerido');
$L['cfg_turnajax'] = array('Deshabilitar AJAX', 'Solo funciona si está habilitado JQuery');
$L['cfg_cache'] = array('Cache interna', 'Dejar habilitado para un mejor rendimiento');
$L['cfg_clustermode'] = array('Cluster de servidores','Fijar si tienes una configuración balanceada.');			// New in v125
$L['cfg_cookiedomain'] = array('Dominio para las cookies', 'Defecto: vacío');
$L['cfg_cookielifetime'] = array('Vida máxima de las cookies', 'En segundos');
$L['cfg_cookiepath'] = array('Ruta para las cookies', 'Defecto: vacío');

$L['cfg_devmode'] = array('Modo Debug', 'No dejar habilitado en sitios en real (productivos)');
$L['cfg_disablehitstats'] = array('Deshabilitar estadísticas de acceso', 'Referentes y accesos por día');
$L['cfg_gzip'] = array('Gzip', 'Compresión GZIP de la salida HTML');
$L['cfg_hostip'] = array('Dirección IP del servidor', 'La dirección IP del servidor, opcional.');
$L['cfg_jquery'] = array('Habilitar JQuery', '');	// New in N-0.0.1
$L['cfg_maintenance'] = array('Modo mantenimiento', 'Permite solo al personal autorizado el acceso al sitio'); // N-0.0.2
$L['cfg_maintenancereason'] = array('Razón de mantenimiento', 'Opcional, mejor que sea corto'); // N-0.0.2
$L['cfg_shieldenabled'] = array('Habilitar la protección (Shield)', 'Anti-spamming y anti-hammering');
$L['cfg_shieldtadjust'] = array('Ajustar contadores Shield (en %)', 'Cuanto más alto, más difícil hacer spam');
$L['cfg_shieldzhammer'] = array('Anti-hammer después de * intentos consecutivos', 'Cuanto más pequeño, más rápidamente entrará en efecto el auto-bloqueo de 3 minutos');
$L['cfg_redirbkonlogin'] = array('Redirigir de vuelta al conectar', 'Redirigir a la página vista antes de conectar');	// New in N-0.6.1
$L['cfg_redirbkonlogout'] = array('Redirigir de vuelta al desconectar', 'Redirigir a la página vista antes de desconectar');	// New in N-0.6.1

/**
 * Config Section
 * Menus Subsection
 */

$L['cfg_banner'] = array('Banner<br />{HEADER_BANNER} en header.tpl', '');
$L['cfg_bottomline'] = array('Bottom line<br />{FOOTER_BOTTOMLINE} en footer.tpl', '');
$L['cfg_topline'] = array('Top line<br />{HEADER_TOPLINE} en header.tpl', '');

$L['cfg_freetext1'] = array('Freetext Slot #1<br />{PHP.cfg.freetext1} en todos los ficheros tpl', '');
$L['cfg_freetext2'] = array('Freetext Slot #2<br />{PHP.cfg.freetext2} en todos los ficheros tpl', '');
$L['cfg_freetext3'] = array('Freetext Slot #3<br />{PHP.cfg.freetext3} en todos los ficheros tpl', '');
$L['cfg_freetext4'] = array('Freetext Slot #4<br />{PHP.cfg.freetext4} en todos los ficheros tpl', '');
$L['cfg_freetext5'] = array('Freetext Slot #5<br />{PHP.cfg.freetext5} en todos los ficheros tpl', '');
$L['cfg_freetext6'] = array('Freetext Slot #6<br />{PHP.cfg.freetext6} en todos los ficheros tpl', '');
$L['cfg_freetext7'] = array('Freetext Slot #7<br />{PHP.cfg.freetext7} en todos los ficheros tpl', '');
$L['cfg_freetext8'] = array('Freetext Slot #8<br />{PHP.cfg.freetext8} en todos los ficheros tpl', '');
$L['cfg_freetext9'] = array('Freetext Slot #9<br />{PHP.cfg.freetext9} en todos los ficheros tpl', '');

$L['cfg_menu1'] = array('Menu slot #1<br />{PHP.cfg.menu1} en todos los ficheros tpl', '');
$L['cfg_menu2'] = array('Menu slot #2<br />{PHP.cfg.menu2} en todos los ficheros tpl', '');
$L['cfg_menu3'] = array('Menu slot #3<br />{PHP.cfg.menu3} en todos los ficheros tpl', '');
$L['cfg_menu4'] = array('Menu slot #4<br />{PHP.cfg.menu4} en todos los ficheros tpl', '');
$L['cfg_menu5'] = array('Menu slot #5<br />{PHP.cfg.menu5} en todos los ficheros tpl', '');
$L['cfg_menu6'] = array('Menu slot #6<br />{PHP.cfg.menu6} en todos los ficheros tpl', '');
$L['cfg_menu7'] = array('Menu slot #7<br />{PHP.cfg.menu7} en todos los ficheros tpl', '');
$L['cfg_menu8'] = array('Menu slot #8<br />{PHP.cfg.menu8} en todos los ficheros tpl', '');
$L['cfg_menu9'] = array('Menu slot #9<br />{PHP.cfg.menu9} en todos los ficheros tpl', '');

/**
 * Config Section
 * Page Subsection
 */

$L['cfg_allowphp_pages'] = array('Permitir tipo de página PHP', 'Ejecución de PHP en las páginas. Usar con precaución!!');
$L['cfg_autovalidate'] = array('Autovalidar página', 'Autovalidar la página si el remitente tiene derechos de administración en la categoría de la página');	// New in N-0.0.2
$L['cfg_count_admin'] = array('Contar las visualizaciones de los administradores', '');	// New in N-0.0.1
$L['cfg_disable_page'] = array('Deshabilitar las páginas', '');
$L['cfg_maxrowsperpage'] = array('Max. líneas en listas', ' ');
$L['cfg_maxlistsperpage'] = array('Max. listas por página', ' '); // New in N-0.0.6

/**
 * Config Section
 * Parser Subsection
 */

$L['cfg_parser_disable'] = array('Deshabilitar intérprete por defecto', '');	// New in N-0.0.3
$L['cfg_parsebbcodecom'] = array('Intrepretar BBcode en los comentarios y los mensajes privados', '');
$L['cfg_parsebbcodeforums'] = array('Interpretar BBcode en los foros', '');
$L['cfg_parsebbcodepages'] = array('Interpretar BBcode en páginas', '');
$L['cfg_parsebbcodeusertext'] = array('Interpretar BBcode en la firma del usuario', '');
$L['cfg_parser_cache'] = array('Habilitar la caché HTML', ''); // N-0.0.1
$L['cfg_parser_custom'] = array('Habilitar intérprete propio', ''); // N-0.0.1
$L['cfg_parser_vid'] = array('Permitir BBcodes para los vídeos', '');		// New in v120
$L['cfg_parser_vid_autolink'] = array('Auto-enlazar URLs a sitios de vídeo conocidos', '');						// New in v120
$L['cfg_parsesmiliescom'] = array('Interpretar smilies en los comentarios y en los mensajes privados', '');
$L['cfg_parsesmiliesforums'] = array('Interpretar smilies en los foros', '');
$L['cfg_parsesmiliespages'] = array('Interpretar smilies en páginas', '');
$L['cfg_parsesmiliesusertext'] = array('Interpretar smilies en la firma del usuario', '');

/**
 * Config Section
 * PFS Subsection
 */

$L['cfg_disable_pfs'] = array('Deshabilitar el '.$L['PFS'], '');
$L['cfg_maxpfsperpage'] = array('Max. elementos por página', ' ');
$L['cfg_pfsfilecheck'] = array('Comprobación de ficheros', 'Si se habilita comprobará cualquier fichero subido a través del '.$L['PFS'].', o las imágenes a través del perfil, para asegurar que son ficheros válidos. &quot;Sí&quot; recomentado, por motivos de seguridad.');	// New in N-0.0.2
$L['cfg_pfsnomimepass'] = array('Permitir sin tipo MIME', 'Si se habilita permitirá subir ficheros que no tengan un tipo MIME conocido por la configuración.');	// New in N-0.0.2
$L['cfg_pfstimename'] = array('Nombres de ficheros basados en timestamp', 'Genera los nombres de fichero basándose en la fecha y hora actual. Por defecto se utiliza el nombre de fichero original con alguna conversión de carácter necesarias.');	// New in N-0.0.2
$L['cfg_pfsuserfolder'] = array('Modo de almacenamiento de carpetas', 'Si se habilita, almacenará los ficheros de los usuarios en subcarpetas /datas/users/USERID/... en lugar de utilizar el USERID como prefijo. Se debe habilitar nada más instalar el sitio. Una vez se suba un fichero ya no es posible cambiar este parámetro. No se recomientda cambiar este parámetro por ahora.');
$L['cfg_pfs_winclose'] = array('Cerrar ventana popup una vez insertado el BBcode');
$L['cfg_th_amode'] = array('Generación de thumbnails', '');
$L['cfg_th_border'] = array('Thumbnails, tamaño del borde', 'Defecto: 4 pixels');
$L['cfg_th_colorbg'] = array('Thumbnails, color del borde', 'Defecto: 000000, código hexa de color');
$L['cfg_th_colortext'] = array('Thumbnails, color del texto', 'Defecto: FFFFFF, código hexa de color');
$L['cfg_th_dimpriority'] = array('Thumbnails, dimensión prioritaria para el escalado', '');
$L['cfg_th_jpeg_quality'] = array('Thumbnails, calidad JPEG', 'Defecto: 85');
$L['cfg_th_keepratio'] = array('Thumbnail, mantener aspecto?', '');
$L['cfg_th_textsize'] = array('Thumbnails, tamaño del texto', '');
$L['cfg_th_x'] = array('Thumbnails, anchura', 'Defecto: 112 pixels');
$L['cfg_th_y'] = array('Thumbnails, altura', 'Defecto: 84 pixels, recomendado: anchura x 0.75');

/**
 * Config Section
 * Plugins Subsection
 */

$L['cfg_disable_plug'] = array('Deshabilitar los plugins', '');

/**
 * Config Section
 * Private Messages Subsection
 */

$L['cfg_disable_pm'] = array('Deshabilitar los mensajes privados', '');
$L['cfg_pm_allownotifications'] = array('Permitir notificaciones de MP por e-mail', '');
$L['cfg_pm_maxsize'] = array('Longitud máxima de los mensajes', 'Defecto: 10000 carácteres');
$L['cfg_maxpmperpage'] = array('Max. mensajes por página', ' ');  // New in N-0.0.6

/**
 * Config Section
 * Polls Subsection
 */

$L['cfg_del_dup_options'] = array('Forzar el borrado de opciones duplicadas', ' Borra las opciones duplicadas incluso si ya existen en la base de datos');	// New in N-0.0.2
$L['cfg_disable_polls'] = array('Deshabilitar las encuestas', '');
$L['cfg_ip_id_polls'] = array('Método de contabilización de votos', '');	// New in N-0.0.2
$L['cfg_max_options_polls'] = array('Máximo número de opciones', 'Las opciones por encima de este límite se borrarán automáticamente'); // N-0.0.2

/**
 * Config Section
 * Ratings Subsection
 */

$L['cfg_disable_ratings'] = array('Deshabilitar las puntuaciones', '');
$L['cfg_ratings_allowchange'] = array('Permitir el cambio de puntuaciones?', 'Si está habilitado los usuario podrán cambiar sus puntuaciones.'); // N-0.0.2

/**
 * Config Section
 * Skins Subsection
 */

$L['cfg_charset'] = array('Juego de carácteres HTML', '');
$L['cfg_disablesysinfos'] = array('Deshabilitar el tiempo de creación de la página', 'En footer.tpl');
$L['cfg_doctypeid'] = array('Tipo de documento', '&lt;!DOCTYPE&gt; del layout HTML');
$L['cfg_forcedefaultskin'] = array('Forzar el skin por defecto para todos los usuarios', '');
$L['cfg_homebreadcrumb'] = array('Mostrar HOME en el Hilo de Ariadna', 'Poner el enlace al principio de la ruta de navegación (Hilo de Ariadna)');	// New in N-0.0.2
$L['cfg_keepcrbottom'] = array('Mantener la nota de copyright en el tag {FOOTER_BOTTOMLINE}', 'En footer.tpl');
$L['cfg_metakeywords'] = array('Meta keywords HTML (separadas por coma)', 'Para los buscadores');
$L['cfg_separator'] = array('Separador genérico', 'Defecto:>');
$L['cfg_showsqlstats'] = array('Mostrar las estadísticas de consultas SQL', 'En footer.tpl');

/**
 * Config Section
 * Time Subsection
 */

$L['cfg_dateformat'] = array('Máscara de fecha principal', 'Defecto: Y-m-d H:i');
$L['cfg_formatmonthday'] = array('Máscara de fecha corta', 'Defecto: m-d');
$L['cfg_formatmonthdayhourmin'] = array('Máscara de fecha en foro', 'Defecto: m-d H:i');
$L['cfg_formatyearmonthday'] = array('Máscara de fecha media', 'Defecto: Y-m-d');
$L['cfg_servertimezone'] = array('Zona horaria del servidor', 'Offset del servidor respecto GMT+00');
$L['cfg_defaulttimezone'] = array('Default time zone', 'For guests and new members, from -12 to +12');
$L['cfg_timedout'] = array('Tiempo de espera, en segundos', 'Después de este tiempo el usuario se considera desconectado');

/**
 * Config Section
 * Title Subsection
 */

$L['cfg_maintitle'] = array('Título del sitio', 'Título principal del sitio web, requerido');
$L['cfg_subtitle'] = array('Descripción', 'Opcional, se mostrará después del título del sitio');
$L['cfg_title_forum_editpost'] = array('Título edición de post en el foro', 'Opciones: {FORUM}, {SECTION}, {EDIT}');
$L['cfg_title_forum_main'] = array('Título principal del foro', 'Opciones: {FORUM}');
$L['cfg_title_forum_newtopic'] = array('Título al crear nuevo mensaje del foro', 'Opciones: {FORUM}, {SECTION}, {NEWTOPIC}');
$L['cfg_title_forum_posts'] = array('Título mensajes del foro', 'Opciones: {FORUM}, {TITLE}');
$L['cfg_title_forum_topics'] = array('Título temas del foro', 'Opciones: {FORUM}, {SECTION}');
$L['cfg_title_header'] = array('Título de la cabecera', 'Opciones: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_header_index'] = array('Título del índice de la cabecera', 'Opciones: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_list'] = array('Título de lista', 'Opciones: {TITLE}');
$L['cfg_title_page'] = array('Título de página', 'Opciones: {TITLE}, {CATEGORY}');
$L['cfg_title_pfs'] = array('Título '.$L['PFS'], 'Opciones: {PFS}');
$L['cfg_title_pm_main'] = array('Título MP', 'Opciones: {PM}, {INBOX}, {ARCHIVES}, {SENTBOX}');
$L['cfg_title_pm_send'] = array('Título enviar MP', 'Opciones: {PM}, {SEND_NEW}');
$L['cfg_title_users_details'] = array('Título detalles de usuario', 'Opciones: {USER}, {NAME}');
$L['cfg_title_users_edit'] = array('Título edición de usuarios', 'Opciones: {EDIT}, {NAME}');
$L['cfg_title_users_main'] = array('Título principal usuarios', 'Opciones: {USERS}');
$L['cfg_title_users_profile'] = array('Título perfil de usuarios', 'Opciones: {PROFILE}, {NAME}');

/**
 * Config Section
 * Trash Subsection
 */

$L['cfg_trash_comment'] = array('Utilizar la papelera de reciclaje para los comentarios', '');		// New in v110
$L['cfg_trash_forum'] = array('Utilizar la papelera de reciclaje para los foros', '');		// New in v110
$L['cfg_trash_page'] = array('Utilizar la papelera de reciclaje para las páginas', '');		// New in v110
$L['cfg_trash_pm'] = array('Utilizar la papelera de reciclaje para los mensajes privados', '');		// New in v110
$L['cfg_trash_prunedelay'] = array('Eliminar permanentemente los objetos de la papelera de reciclaje después de * días (cero para no borrar nunca)', ''); 	// New in v110
$L['cfg_trash_user'] = array('Utilizar la papelera de reciclaje para los usuarios', '');		// New in v110


/**
 * Config Section
 * Users Subsection
 */

$L['cfg_av_maxsize'] = array('Avatar, tamaño máximo del fichero', 'Defecto: 8000 bytes');
$L['cfg_av_maxx'] = array('Avatar, anchura máxima', 'Defecto: 64 pixels');
$L['cfg_av_maxy'] = array('Avatar, altura máxima', 'Defecto: 64 pixels');
$L['cfg_disablereg'] = array('Deshabilitar el registro de usuarios','Evita que los usuario registren nuevas cuentas');
$L['cfg_disablewhosonline'] = array('Deshabilitar quien está en línea', 'Automáticamente fijado si habilitas el Shield');
$L['cfg_maxusersperpage'] = array('Máximo número de líneas en la lista de usuarios', '');
$L['cfg_ph_maxsize'] = array('Photo, tamaño máximo del fichero', 'Default: 8000 bytes');
$L['cfg_ph_maxx'] = array('Photo, anchura máxima', 'Defecto: 96 pixels');
$L['cfg_ph_maxy'] = array('Photo, altura máxima', 'Defecto: 96 pixels');
$L['cfg_regnoactivation'] = array('No hacer el chequeo de e-mail para nuevos usuarios', '\'No\' se recomienda, por motivos de seguridad');
$L['cfg_regrequireadmin'] = array('Los administradores deben validar las nuevas cuentas', '');
$L['cfg_sig_maxsize'] = array('Firma, tamaño máximo del fichero', 'Defecto: 50000 bytes');
$L['cfg_sig_maxx'] = array('Firma, anchura máxima', 'Defecto: 468 pixels');
$L['cfg_sig_maxy'] = array('Firma, altura máxima', 'Defecto: 60 pixels');
$L['cfg_user_email_noprotection'] = array('Deshabilitar el cambio de e-mail protegido por contraseña', '\'No\' recomendado por motivos de seguridad');
$L['cfg_useremailchange'] = array('Permitir a los usuarios cambiar su e-mail', '\'No\' recomendado por motivos de seguridad');
$L['cfg_usertextimg'] = array('Permitir imágenes y HTML en la firma del usuario', '\'No\' recomendado por motivos de seguridad');
$L['cfg_usertextmax'] = array('Longitud máxima de la firma del usuario', 'Defecto: 300 carácteres');

/**
  * Page Section
 */

$L['addnewentry'] = 'Añadir una nueva entrada';
$L['adm_valqueue'] = 'Esperando validación';
$L['adm_structure'] = 'Estructura de las páginas (categorías)';
$L['adm_extrafields_desc'] = 'Añadir/editar campos extra';
$L['adm_sortingorder'] = 'Fija un órden por defecto para las categorías';
$L['adm_showall'] = 'Mostrar todo';
$L['adm_help_page'] = 'Las páginas que perteneces a la categoría &quot;system&quot; no se muestran en los listados públicos, sirve para hacer páginas aisladas.';

/**
  * Page Section
  * Structure Subsection
 */

$L['adm_tpl_empty'] = 'Defecto';	// New in v110
$L['adm_tpl_forced'] = 'Igual que';	// New in v110
$L['adm_tpl_mode'] = 'Modo de Template';	// New in v110
$L['adm_tpl_parent'] = 'Igual que la categoría padre';	// New in v110
$L['adm_enablecomments'] = 'Habilitar comentarios';	// New in N-0.1.0
$L['adm_enableratings'] = 'Habilitar puntuaciones';	// New in N-0.1.0

/**
 * Page Section
 * Extrafields Subsection
 */

$L['adm_help_pages_extrafield'] = '<b>Base HTML</b> fijado automáticamente si lo dejas en blanco<br /><br />
<b>Nuevos tags en los ficheros tpl:</b><br /><br />
page.tpl: {PAGE_XXXXX}, {PAGE_XXXXX_TITLE}<br /><br />
page.add.tpl: {PAGEADD_FORM_XXXXX}, {PAGEADD_FORM_XXXXX_TITLE}<br /><br />
page.edit.tpl: {PAGEEDIT_FORM_XXXXX}, {PAGEEDIT_FORM_XXXXX_TITLE}<br /><br />
list.tpl: {LIST_ROW_XXXXX}, {LIST_TOP_XXXXX}<br />';

/**
  * Page Section
  * CatOrder Subsection
 */

$L['adm_filecount'] = 'Descargas del fichero';
$L['adm_filesize'] = 'Tamaño del fichero';
$L['adm_fileurl'] = 'URL del fichero';
$L['adm_fileyesno'] = 'Fichero (sí/no)';

/**
 * Forums Section
 */

$L['adm_forum_structure'] = 'Estructura de los foros (categorías)';	// New in v110
$L['adm_forum_emptytitle'] = 'Error: título vacío';	// New in N-0.1.0

/**
  * Forums Section
  * Structure Subsection
 */

$L['adm_defstate'] = 'Estado por defecto';	// New in v110
$L['adm_defstate_0'] = 'Plegado';	// New in v110
$L['adm_defstate_1'] = 'Desplegado';	// New in v110

/**
  * Forums Section
  * Forum Edit Subsection
 */

$L['adm_forums_master'] = 'Sección maestra';  // N-0.0.1
$L['adm_diplaysignatures'] = 'Mostrar firmas';
$L['adm_enablebbcodes'] = 'Habilitar BBcodes';
$L['adm_enablepolls'] = 'Habilitar encuestas';  // N-0.0.2
$L['adm_enableprvtopics'] = 'Permitir temas privados';
$L['adm_enablesmilies'] = 'Habilitar smilies';
$L['adm_enableviewers'] = 'Habilitar visualizadores';  // N-0.0.2
$L['adm_countposts'] = 'Contabilizar mensajes';
$L['adm_autoprune'] = 'Auto-purgar temas después de * días';
$L['adm_postcounters'] = 'Comprobar los contadores';

/**
 * Users Section
 */

$L['adm_rightspergroup'] ='Derechos por grupo';
$L['adm_maxsizeallpfs'] ='Tamaño máximo de todos los ficheros del '.$L['PFS'].' (KB)';
$L['adm_maxsizesingle'] ='Tamaño máximo para un ficheero del '.$L['PFS'].' (KB)';
$L['adm_copyrightsfrom'] ='Fijar los mismos derechos que el grupo';
$L['adm_rights_maintenance'] ='Acceso al sitio cuando está habilitado el modo de mantenimiento';

/**
 * Users Section
 * Extrafields Subsection
 */

$L['adm_help_users_extrafield'] = '<b>Base HTML</b> fijado automáticamente si se deja en blanco<br /><br />
<b>Nuevos tags en los ficheros tpl:</b><br /><br />
users.profile.tpl: {USERS_PROFILE_XXXXX}, {USERS_PROFILE_XXXXX_TITLE}<br /><br />
users.edit.tpl: {USERS_EDIT_XXXXX}, {USERS_EDIT_XXXXX_TITLE}<br /><br />
users.details.tpl: {USERS_DETAILS_XXXXX}, {USERS_DETAILS_XXXXX_TITLE}<br /><br />
user.register.tpl: {USERS_REGISTER_XXXXX}, {USERS_REGISTER_XXXXX_TITLE}<br /><br />
forums.posts.tpl: {FORUMS_POSTS_ROW_USERXXXXX}, {FORUMS_POSTS_ROW_USERXXXXX_TITLE}<br />';

/**
 * Plug Section
 */

$L['adm_defauth_guests'] ='Derechos por defecto de los invitados';
$L['adm_deflock_guests'] ='Máscara por defecto de los invitados';
$L['adm_defauth_members'] ='Derechos por defecto de los miembros';
$L['adm_deflock_members'] ='Máscara de bloqueo de los miembros';

$L['adm_present'] ='Presente';
$L['adm_missing'] ='Falta';
$L['adm_paused'] ='Detenido';
$L['adm_running'] ='En ejecución';
$L['adm_partrunning'] ='En ejecución parcialmente';
$L['adm_partstopped'] = 'Detenido parcialmente';
$L['adm_installed'] = 'Instalado';	// New in N-0.0.6
$L['adm_notinstalled'] ='No instalado';

$L['adm_plugsetup'] = 'Instalación de plugin';	// New in N-0.0.6
$L['adm_override_guests'] = 'Ignorar sistema, invitados y baneados no puedes administrar';	// New in N-0.0.6
$L['adm_override_banned'] = 'Ignorar sistema, baneados';	// New in N-0.0.6
$L['adm_override_admins'] = 'Ignorar sistema, administradores';	// New in N-0.0.6

$L['adm_opt_setoption_warn'] = 'Se han encontrado opciones para este plugin. ¿Quieres instalarlo usando esas opciones?';	// New in N-0.0.2
$L['adm_opt_uninstall_warn'] = 'Puedes borrar este plugin sin borrar las opciones de configuración (derechos y opciones). Pulsa para hacerlo.';	// New in N-0.0.2
$L['adm_opt_setup_missing'] = 'Error: falta el fichero de setup!';	// New in N-0.0.6
$L['adm_opt_installall'] ='Instalar todo';
$L['adm_opt_installall_explain'] ='Esto instalará o reiniciará todas las partes del plugin.';
$L['adm_opt_pauseall'] ='Pausar todo';
$L['adm_opt_pauseall_explain'] ='Esto pausará (deshabilitará) todas las partes del plugin';
$L['adm_opt_setoption_warn'] ='Se han encontrado opciones para este plugin. ¿Quieres instalarlo desde las opciones guardadas?';
$L['adm_opt_uninstall_warn'] ='Puedes borrar el plugin sin borrar las opciones de configuración (permisos y opciones). Pulsa si quieres hacerlo.';
$L['adm_opt_uninstallall'] ='Desinstalar todo</a></td>';
$L['adm_opt_uninstallall_explain'] ='Esto deshabilitará todas las partes del plugin, pero no borrará físicamente los ficheros.';
$L['adm_opt_unpauseall'] ='Reiniciar todo';
$L['adm_opt_unpauseall_explain'] ='Esto reiniciará todas las partes pausadas de un plugin.';

$L['adm_pluginstall_msg01'] = 'Borrando la instalación antigua de este plugin...';	// New in N-0.0.6
$L['adm_pluginstall_msg02'] = 'Borrando las entradas de configuración antiguas...';	// New in N-0.0.6
$L['adm_pluginstall_msg03'] = 'Buscando el fichero de setup...';	// New in N-0.0.6
$L['adm_pluginstall_msg04'] = 'Buscando partes...';	// New in N-0.0.6
$L['adm_pluginstall_msg05'] = 'Instalando las partes...';	// New in N-0.0.6
$L['adm_pluginstall_msg06'] = 'Buscando entradas de configuración en el fichero de setup...';	// New in N-0.0.6
$L['adm_pluginstall_msg07'] = 'No encontrado! Ha fallado la instalación!';	// New in N-0.0.6
$L['adm_pluginstall_msg08'] = 'Borrando los permisos antiguos referentes a este plugin...';	// New in N-0.0.6
$L['adm_pluginstall_msg09'] = 'Añadiendo los derechos para los grupos de usuariso...';	// New in N-0.0.6
$L['adm_pluginstall_msg10'] = 'Reiniciando la columna auth para todos los usuarios...';	// New in N-0.0.6
$L['adm_pluginstall_msg11'] = 'Ejecutando la parte de instalación del script de instalación...';	// New in N-0.0.6

/**
 * Tools Section
 */

$L['adm_listisempty'] = 'La lista está vacía';

/**
  * TrashCan Section
 */

$L['adm_help_trashcan'] ='Aquí se listan los objetos borrados recientemente por los usuarios y los moderadores.<br />Te en cuenta que recuperar un tema del foro restaurará también todos los mensajes que pertenezcan al mismo.<br /> Y que recuperar un mensaje de un tema borrado restaurará todo el tema (si está disponible) y todos los mensajes hijos de él.<br />&nbsp;<br />Purgar : Borrar el objeto de manera permanente.<br />Recuperar : Devolver el objeto a la base de datos productiva (en real).';

/**
 * Other Section
 * Comments Subsection
 */

$L['adm_comm_already_del'] = 'Comentario borrado';		//N-0.0.2

/**
 * Other Section
 * PFS Subsection
 */

$L['adm_gd'] = 'Librería gráfica GD';
$L['adm_allpfs'] = 'Todos los PFS';
$L['adm_allfiles'] = 'Todos los ficheros';
$L['adm_thumbnails'] = 'Thumbnails';
$L['adm_orphandbentries'] = 'Entradas huérfanas en la base de datos';
$L['adm_orphanfiles'] = 'Ficheros huérfanos';
$L['adm_delallthumbs'] = 'Borrar todos los thumbnails';
$L['adm_rebuildallthumbs']= 'Borrar y reconstruir todos los thumbnails';
$L['adm_help_allpfs'] = $L['PFS'].' de todos los usuarios registrados';
$L['adm_nogd'] = 'La librería gráfica GD no está soportada por este host, Cotonti no será capaz de crear thumbnails para las imágenes del PFS. Debes ir a '.$L['Configuration'].' &gt; '.$L['PFS'].' y fijar la generación de Thumbnails = &quot;'.$L['Disabled'].'&quot;.';
/**
 * Other Section
 * Polls Subsection
 */

$L['adm_help_polls'] ='Rellena el formulario y pulsa el botón de &quot;Crear&quot;  para empezar una nueva encuesta. Las opciones vacías se ignorarán y se borrarán. No es recomendable que modifiques la encuesta una vez creada o comprometerás los resultados de la misma.';
$L['adm_polls_msg916_bump'] = 'Golpeada con éxito!';	// New in N-0.0.3
$L['adm_polls_msg916_deleted'] = 'Borrada con éxito!';	// New in N-0.0.3
$L['adm_polls_msg916_reset'] = 'Reiniciada con éxito!';	// New in N-0.0.3
$L['adm_polls_on_page'] = 'en la página';	// New in N-0.0.2
$L['adm_polls_polltopic'] = 'Tema de la encuesta';	// New in N-0.0.1
$L['adm_polls_forumpolls'] ='Encuestas de los foros (las más recientes arriba):';
$L['adm_polls_indexpolls'] ='Encuestas de índice (las más recientes arriba):';

/**
 * Other Section
 * PM Subsection
 */

$L['adm_pm_totaldb'] ='Mensajes privados en la base de datos';
$L['adm_pm_totalsent'] ='Mensajes privados enviados en total';

/**
 * Other Section
 * Ratings Subsection
 */

$L['adm_ratings_already_del'] = 'Puntuación borrada';	// New in N-0.0.3
$L['adm_ratings_totalitems'] ='Páginas puntuadas';
$L['adm_ratings_totalvotes'] ='Votos totales';
$L['adm_help_ratings'] ='Para reiniciar una puntuación, basta con borrarla. Se recreará con el primer voto nuevo.';


/**
 * Other Section
 * Cache Subsection
 */

$L['adm_delcacheitem'] = 'Objeto de caché borrado';		//N-0.0.2
$L['adm_internalcache'] = 'Caché interna';
$L['adm_purgeall_done'] = 'Caché borrada completamente';		//N-0.0.2
$L['adm_diskcache'] = 'Caché de disco';	// New in N-0.6.1

/**
 * Other Section
 * BBCode Subsection
 */

$L['adm_bbcode'] = 'BBCode';
$L['adm_bbcodes'] = 'BBCodes';
$L['adm_bbcodes_added'] = 'Se ha añadido con éxito el nuevo BBCode.';
$L['adm_bbcodes_clearcache'] = 'Vaciar caché HTML';
$L['adm_bbcodes_clearcache_confirm'] = 'Esto limpiará la caché para todas las páginas y mensajes. Continuar?';
$L['adm_bbcodes_clearcache_done'] = 'La caché HTML se ha borrado.';
$L['adm_bbcodes_confirm'] = 'Borrar este bbcode?';
$L['adm_bbcodes_container'] = 'Contenedor';
$L['adm_bbcodes_mode'] = 'Mod';
$L['adm_bbcodes_new'] = 'Nuevo BBCode';
$L['adm_bbcodes_pattern'] = 'Patrón';
$L['adm_bbcodes_postrender'] = 'Post-render';
$L['adm_bbcodes_priority'] = 'Prioridad';
$L['adm_bbcodes_removed'] = 'BBcode borrado con éxito.';
$L['adm_bbcodes_replacement'] = 'Reemplazo';
$L['adm_bbcodes_updated'] = 'BBcode actualizado con éxito.';
$L['adm_help_bbcodes'] = <<<HTM
<ul>
<li><strong>Nombre</strong> - nombre del BBcode (usa alfanuméricos y subrayado únicamente)</li>
<li><strong>Modo</strong> - Modo de interpretación, uno de los siguientes: 'str' (str_replace), 'ereg' (eregi_replace), 'pcre' (preg_replace) y 'callback' (preg_replace_callback)</li>
<li><strong>Patrón</strong> - cadena del BBcode o una expresión regular entera</li>
<li><strong>Reemplazo</strong> - cadena de reemplazo o sustitución regular o cuerpo de callback</li>
<li><strong>Contenedor</strong> - Indica si el BBcode es un contenedor (como por ejemplo [bbcode]lo que sea[/bbcode])</li>
<li><strong>Prioridad</strong> - Prioridad del BBcode de 0 a 255. Los BBCodes con prioridad menor se interpretan antes, siendo 128 la prioridad por defecto.</li>
<li><strong>Plugin</strong> - Plugin/nombre de la parte a la que pertenece el BBcode. Dejar en blanco pues esto es únicamente para plugins.</li>
<li><strong>Post-render</strong> - Indica si el BBcode debe aplicarse en una caché HTML pre-renderizada. Usar solo si tu callback hace cálculos por petición.</li>
</ul>
HTM;

/**
 * Other Section
 * URLs Subsection
 */

$L['adm_urls'] = 'URLs';
$L['adm_urls_area'] = 'Área';
$L['adm_urls_callbacks'] = 'Regla contiene callbacks';
$L['adm_urls_error_dat'] = 'Error: no se puede escribir en datas/urltrans.dat!';
$L['adm_urls_errors'] = 'Necesitarás añadir las opciones de rewrite manualmente.';
$L['adm_urls_format'] = 'Formato';
$L['adm_urls_htaccess'] = 'Sobreescribir .htaccess?';
$L['adm_urls_new'] = 'Nueva regla';
$L['adm_urls_parameters'] = 'Parámetros';
$L['adm_urls_rules'] = 'Reglas de transformación de URL';
$L['adm_urls_save'] = 'Guardar';
$L['adm_urls_your'] = 'Tu';
$L['adm_help_urls'] = 'En esta página puedes personalizar tus URL utilizando reglas sencillas de transformación. Por favor asegurate que las reglas son correctas y que no hay duplicados. No utilices espacios, tabuladores u otros carácteres especiales en las reglas. Las secciones y los parámetros se explican más abajo.<ol>
<li><strong>Área</strong> es el nombre del script al que pertenece la regla. El metasímbolo (*) significa &quot;cualquier script&quot;.</li>
<li><strong>Parametros</strong> son la condición que se valida contra los parámetros de la URL. Es una cadena de texto, que contiene pares de nombre-valor sepadados con &amp; y el símbolo = usado entre el nombre y el valor. No es necesario el símbolo ? al principio. Si especificas una variable aquí, debe estar presente en la URL para que active la regla.
Puedes usar * que quiere decir &quot;cualquier valor&quot;, un valor simple, o una lista de los posibles valores separados con el símbolo |. Todos los valores deben estar codificados como una URL. <em>Ejemplo: name=Val|Josh&amp;id=124&amp;page=*</em>.</li>
<li><strong>Formato</strong> fija el formato de las URLs que concuerdan con esta regla. Es una cadena de texto que contiene secuencias especiales sustituidas por su valor. Una secuencia normal se parece a {$name} donde &quot;name&quot; es el nombre del parámetro de URL (la variable GET), cuyo valor se insertará en lugar de esta secuencia. Hay varias secuencias especiales que no son parámetros URL (&quot;cadena de consulta&quot;):
	<ul>
		<li><em>{$_area}</em> - nombre del script;</li>
		<li><em>{$_host}</em> - nombre del host de tu URL principal;</li>
		<li><em>{$_rhost}</em> - nombre del host de la petición HTTP actual;</li>
		<li><em>{$_path}</em> - ruta relativa al servidor de tu sitio, / si el sitio está en la raíz del servidor.</li>
	</ul>
Puedes también utilizar subdominios parametrizados especificando una URL en formato absoluto como por ejemplo: <em>http://{$c}.site.com/{$al}.html</em>.
De momento los subdominios solo se soportan para servidores Apache.
</li>
<li><strong>Nueva regla</strong> añade una línea de nueva regla a la tabla.</li>
<li><strong>Order</strong> - ten en cuenta que el orden de las reglas en la tabla es importante. El algoritmo de transformación de URL mira las reglas para un enlace de la siguiente manera: primero lee todas las reglas definidas para el área, entonces intenta encontrar <em>la primera</em> regla que concuerde con la condición de parámetros; si no encuentra una regla que concuerde, intentará ir al área * y comprobar la primera regla ahí. Se recomienda que tu regla por defecto (con área * y parámetros *) sea la última de las reglas del área *, o incluso la última de la tabla.<br />
Puedes cambiar el orden de las reglas arrastrando las líneas y soltándolas en las posiciones deseadas. 
Se recomienda que guardes las nuevas reglas antes de cambiar su órden arrastrándolas.</li>
<li><strong>Cadena de consulta</strong> es lo que usualmente ves en los enlaces después del signo de interrogación. Se usa para pasar el resto de parámetros GET que no has utilizado en el resto de la cadena de formato y se añade automáticamente en ese caso.</li>
<li><strong>Guardar</strong> salvará las reglas y las aplicará de manera inmediata. También aplicará los cambios en tu fichero .htaccess (si se puede por permisos) y te proveerá con .htaccess/IsapiRewrite4.ini/nginx.conf (dependiendo del tipo de servidor).</li>
</ol>';
/**
 * Other Section
 * Banlist Subsection
 */

$L['adm_ipmask'] = 'Máscara de IP';
$L['adm_emailmask'] = 'Máscara de e-mail';
$L['adm_neverexpire'] = 'Nunca caduca';
$L['adm_help_banlist'] = 'Ejemplos de máscaras de IP: 194.31.13.41 , 194.31.13.* , 194.31.*.* , 194.*.*.*<br />Ejemplos de máscaras de e-mail: @hotmail.com, @yahoo (No se soportan asteriscos)<br />Una línea individual solo puede contener una máscara de IP, una máscara de e-mail o ambas.<br />Las direcciones IP se filtran para cada página mostrada, y la máscara de e-mail solo tiene efecto en el momento del registro de usuarios nuevos.';

$L['adm_searchthisuser'] = 'Buscar esta dirección IP en la base de datos de usuarios';
$L['adm_dnsrecord'] = 'Registro DNS para esta dirección';

$L['alreadyaddnewentry'] = 'Nueva entrada añadida';		//N-0.0.2
$L['alreadydeletednewentry'] = 'Entrada borrada';		//N-0.0.2
$L['alreadyupdatednewentry'] = 'Entrada actualizada';		//N-0.0.2


/**
 * Other Section
 * Hits Subsection
 */

$L['adm_bymonth'] ='Por mes';
$L['adm_byweek'] ='Por semana';
$L['adm_byyear'] ='Por año';

$L['adm_ref_lowhits'] ='Purgar entradas con menos de 5 visualizaciones';
$L['adm_maxhits'] ='El máximo de visualizaciones se alcanzó el  %1$s,  y se visualizaron %2$s pages ese día.';

/**
 * Other Section
 * Referers Subsection
 */

$L['adm_ref_prune'] = 'Borrado';
$L['adm_ref_prunelowhits'] = 'Los referentes con un número de visitantes menor a 5 se han borrado con éxito';

/**
 * Other Section
 * Log Subsection
 */

$L['adm_log'] ='Log del sistema';
$L['adm_infos'] ='Informaciones';
$L['adm_versiondclocks'] ='Versiones y relojes';
$L['adm_hits'] ='Visualizaciones';
$L['adm_check_ok'] = 'Ok';
$L['adm_check_missing'] ='Falta';
$L['adm_checkcorenow'] ='Comprobar ahora los ficheros del núcleo!';
$L['adm_checkcoreskins'] ='Comprobar ficheros del núcleo y relojes';
$L['adm_checkingcore'] ='Comprobando los ficheros del núcleo…';
$L['adm_checkingskin'] ='Comprobando el skin';
$L['adm_checkskin'] ='Comprobar los ficheros TPL del skin';
$L['adm_checkskins'] ='Comprobar si están presentes todos los ficheros del skin';


/**
 * Other Section
 * Infos Subsection
 */

$L['adm_phpver'] = 'Versión del motor PHP';
$L['adm_zendver'] ='Versión del motor Zend';
$L['adm_interface'] ='Interfaz entre el servidor web y PHP';
$L['adm_os'] ='Sistema operativo';
$L['adm_clocks'] ='Relojes';
$L['adm_time1'] ='#1 : Hora bruta del servidor';
$L['adm_time2'] ='#2 : Hora GMT devuelta por el servidor';
$L['adm_time3'] ='#3 : Hora GMT + offset del servidor (referencia Cotonti)';
$L['adm_time4'] ='#4 : Tu hora local, ajustada desde tu perfil';
$L['adm_help_versions'] ='Ajusta la zona horaria del servidor de manera que el reloj #3 esté correctamete fijado.<br />El reloj #4 depende de la zona horaria fijada en tu perfil.<br />Los relojes #1 y #2 se ignoran por Cotonti.';

/**
 * Common Entries
 */

$L['adm_area'] = 'Área';
$L['adm_clicktoedit'] = '(Pulsa para editar)';
$L['adm_confirm'] = 'Pulsa este botón para confirmar : ';
$L['adm_done'] = 'Hecho';
$L['adm_failed'] = 'Falló';
$L['adm_from'] = 'De';
$L['adm_more'] = 'Más herramientas...';
$L['adm_purgeall'] = 'Borrar todo';
$L['adm_queue_unvalidated'] = 'Sin validar';	// New in N-0.0.3
$L['adm_queue_validated'] = 'Validado';	// New in N-0.0.3
$L['adm_required'] = '(Requerido)';
$L['adm_setby'] = 'Fijado por';
$L['adm_to'] = 'Para';
$L['adm_totalsize'] = 'Tamaño total';
$L['adm_warnings'] = 'Advertencias';

$L['editdeleteentries'] = 'Editar o borrar entradas';
$L['viewdeleteentries'] = 'Ver o editar entradas';

/**
 * Extra Fields (Common Entries for Pages & Users)
 */

$L['adm_extrafield_added'] = "Se ha añadido con éxito el campo extra.";
$L['adm_extrafield_confirmdel'] = 'Realmente quieres borrar este campo extra? Todos los datos de este campo se perderán!!';
$L['adm_extrafield_confirmupd'] = 'Realmente quieres actualizar este campo extra? Es posible que se pierdan algunos datos de este campo!';
$L['adm_extrafield_new'] = 'Nuevo campo extra';
$L['adm_extrafield_noalter'] = 'No añadir el campo a la base de datos, únicamente registrarlo como extra';
$L['adm_extrafield_not_added'] = "Error! no se ha añadido el campo extra.";
$L['adm_extrafield_not_removed'] = 'Error! El campo extra no se ha borrado.';
$L['adm_extrafield_not_updated'] = 'Error! El campo extra no se ha actualizado.';
$L['adm_extrafield_removed'] = 'Se ha borrado con éxito el campo extra.';
$L['adm_extrafield_selectable_values'] = 'Opciones para la selección, (separadas por coma):';
$L['adm_extrafield_updated'] = "Se ha modificado con éxito el campo extra.";
$L['adm_extrafields'] = "Campos extra";
$L['adm_help_extrafield'] = 'Ayuda: el Campo &quot;Base HTML&quot; se fija por defecto si lo dejas en blanco y pulsas actualizar.';
                      
$L['extf_Base_HTML'] = "Base HTML";
$L['extf_Description'] = "Descripción (_TITLE)";
$L['extf_Name'] = "Nombre";
$L['extf_Page_tags'] = "Tags";
$L['extf_Type'] = "Tipo de campo";

/**
 * Help messages that still don't work
 */

$L['adm_help_cache'] = 'No disponible';
$L['adm_help_check1'] = 'No disponible';
$L['adm_help_check2'] = 'No disponible';
$L['adm_help_config']= 'No disponible';
$L['adm_help_forums'] = 'No disponible';
$L['adm_help_forums_structure'] = 'No disponible';
$L['adm_help_pfsfiles'] = 'No disponible';
$L['adm_help_pfsthumbs'] = 'No disponible';

?>