<?php
/**
 * Extra header and footer: functions and globals for 'Plugins' location
 *
 * @package extrahf
 * @version 2009-07-05
 * @author dervan
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Globals
 */

$exhf_part = '';

return;

/**
 * Functions
 */

/**
 * Updates $location for plug
 *
 * @global $cfg
 * @global $skin
 * @global $location
 * @global $e
 * @global $exhf_part
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_update_location($part)
{
	global $cfg, $skin, $location, $e, $exhf_part;

	$loc = 'plugins';
	if (empty($exhf_part)
		&& 'code' == $cfg['plugin']['extrahf']["exhf_c_plu$part"]
		&& !empty($e) && file_exists("skins/$skin/$part.$loc.$e.tpl")
		)
	{
		$location = "$loc.$e";
		$exhf_part = $part;
		return;
	}
}

/**
 * Recovers native $location for plug
 *
 * @global $location
 * @global $exhf_part
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_recover_location($part)
{
	global $location, $exhf_part;

	if (!empty($exhf_part) && $exhf_part == $part)
	{
		$location = 'Plugins'; // see plug.php
		$exhf_part = '';
	}
}
?>