<?php
/**
 * Extra header and footer: functions and globals for 'Pages' location with defined('SED_PAGE')
 *
 * @package extrahf
 * @version 2009-07-05
 * @author dervan
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Globals
 */

$exhf_part = '';
switch ($m)
{
	case 'add':
	case 'edit':
		$exhf_what = $m;
		$exhf_alias = $exhf_pageid = '';
	break;

	default:
		$exhf_what = '';
		$exhf_alias = strtolower($pag['page_alias']);
		$exhf_pageid = "pg{$pag['page_id']}";
	break;
}
$exhf_category = exhf_normalize_code($sed_cat[isset($newpagecat) ? $newpagecat : $pag['page_cat']]['tpl']);

return;

/**
 * Functions
 */

/**
 * Updates $location for page
 *
 * @global $cfg
 * @global $skin
 * @global $location
 * @global $exhf_part
 * @global $exhf_what
 * @global $exhf_alias
 * @global $exhf_pageid
 * @global $exhf_category
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_update_location($part)
{
	global $cfg, $skin, $location, $exhf_part, $exhf_what, $exhf_alias, $exhf_pageid, $exhf_category;

	if (!empty($exhf_part))
	{
		return;
	}

	switch ($cfg['plugin']['extrahf']["exhf_c_pag$part"])
	{
		case 'alias or page_id or category':
			$sufx_a = array($exhf_alias, $exhf_pageid, $exhf_category,);
		break;

		case 'category or alias or page_id':
			$sufx_a = array($exhf_category, $exhf_alias, $exhf_pageid,);
		break;

		case 'alias or page_id':
			$sufx_a = array($exhf_alias, $exhf_pageid,);
		break;

		case 'category':
			$sufx_a = array($exhf_category,);
		break;

		case 'default':
		default:
			return;
		break;
	}

	$uri = "skins/$skin/$part";
	$loc = 'pages';
	$what_a = empty($exhf_what) ? array($loc,) : array("$loc.$exhf_what", $loc,);
	foreach ($sufx_a as $sufx)
	{
		if (!empty($sufx))
		{
			foreach ($what_a as $what)
			{
				if (file_exists("$uri.$what.$sufx.tpl"))
				{
					$location = "$what.$sufx";
					$exhf_part = $part;
					return;
				}
			}
		}
	}
	if (!empty($exhf_what) && file_exists("$uri.$loc.$exhf_what.tpl"))
	{
		$location = "$loc.$exhf_what";
		$exhf_part = $part;
		return;
	}
}

/**
 * Recovers native $location for page
 *
 * @global $location
 * @global $exhf_part
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_recover_location($part)
{
	global $location, $exhf_part;

	if (!empty($exhf_part) && $exhf_part == $part)
	{
		$location = 'Pages'; // see page.php
		$exhf_part = '';
	}
}

/**
 * Returns normalized code
 *
 * @param string $code Code of category
 * @return string
 */
function exhf_normalize_code($code)
{
	$code = strtr($code, ' .', '__');
	$code = preg_replace('#[^a-zA-Z0-9\-_]#', '', $code);

	return strtolower($code);
}
?>