<?php
/**
 * Extra header and footer: functions and globals for 'Pages' location with defined('SED_LIST')
 *
 * @package extrahf
 * @version 2009-07-05
 * @author dervan
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Globals
 */

$exhf_part = '';
$exhf_what = 'list' . ($sed_cat[$c]['group'] ? '.group' : '');
$exhf_category = exhf_normalize_code($sed_cat[$c]['tpl']);

return;

/**
 * Functions
 */

/**
 * Updates $location for list
 *
 * @global $cfg
 * @global $skin
 * @global $location
 * @global $exhf_part
 * @global $exhf_what
 * @global $exhf_category
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_update_location($part)
{
	global $cfg, $skin, $location, $exhf_part, $exhf_what, $exhf_category;

	if (!empty($exhf_part)
		|| $cfg['plugin']['extrahf']["exhf_c_lst$part"] != 'category'
		)
	{
		return;
	}

	$uri = "skins/$skin/$part";
	if (!empty($exhf_category) && file_exists("$uri.$exhf_what.$exhf_category.tpl"))
	{
		$location = "$exhf_what.$exhf_category";
		$exhf_part = $part;
		return;
	}
	if (file_exists("$uri.$exhf_what.tpl"))
	{
		$location = $exhf_what;
		$exhf_part = $part;
		return;
	}
}

/**
 * Recovers native $location for list
 *
 * @global $location
 * @global $exhf_part
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_recover_location($part)
{
	global $location, $exhf_part;

	if (!empty($exhf_part) && $exhf_part == $part)
	{
		$location = 'Pages'; // see list.php
		$exhf_part = '';
	}
}

/**
 * Returns normalized code
 *
 * @param string $code Code of category
 * @return string
 */
function exhf_normalize_code($code)
{
	$code = strtr($code, ' .', '__');
	$code = preg_replace('#[^a-zA-Z0-9\-_]#', '', $code);

	return strtolower($code);
}
?>