<?php
/**
 * Extra header and footer: functions and globals for 'Forums' location
 *
 * @package extrahf
 * @version 2009-07-05
 * @author dervan
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Globals
 */

$exhf_part = '';
switch ($m)
{
	case 'editpost':
		$exhf_what = $m;
		$exhf_sectid = "fs$fp_sectionid";
		$exhf_category = exhf_normalize_code($fs_category);
	break;

	case 'newtopic':
	case 'posts':
	case 'topics':
		$exhf_what = $m;
		$exhf_sectid = "fs$s";
		$exhf_category = exhf_normalize_code($fs_category);
	break;

	default:
		$exhf_what = $exhf_sectid = $exhf_category = '';
	break;
}

return;

/**
 * Functions
 */

/**
 * Updates $location for forums
 *
 * @global $cfg
 * @global $skin
 * @global $location
 * @global $exhf_part
 * @global $exhf_what
 * @global $exhf_sectid
 * @global $exhf_category
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_update_location($part)
{
	global $cfg, $skin, $location, $exhf_part, $exhf_what, $exhf_sectid, $exhf_category;

	if (!empty($exhf_part))
	{
		return;
	}

	switch ($cfg['plugin']['extrahf']["exhf_c_frm$part"])
	{
		case 'section_id or category':
			$sufx_a = array($exhf_sectid, $exhf_category,);
		break;

		case 'category or section_id':
			$sufx_a = array($exhf_category, $exhf_sectid,);
		break;

		case 'section_id':
			$sufx_a = array($exhf_sectid,);
		break;

		case 'category':
			$sufx_a = array($exhf_category,);
		break;

		case 'default':
		default:
			return;
		break;
	}

	$uri = "skins/$skin/$part";
	$loc = 'forums';

	if (empty($exhf_what))
	{
		if (file_exists("$uri.$loc.sections.tpl"))
		{
			$location = "$loc.sections";
			$exhf_part = $part;
		}
		return;
	}

	$what_a = array("$loc.$exhf_what", $loc,);
	foreach ($sufx_a as $sufx)
	{
		if (!empty($sufx))
		{
			foreach ($what_a as $what)
			{
				if (file_exists("$uri.$what.$sufx.tpl"))
				{
					$location = "$what.$sufx";
					$exhf_part = $part;
					return;
				}
			}
		}
	}
	if (file_exists("$uri.$loc.$exhf_what.tpl"))
	{
		$location = "$loc.$exhf_what";
		$exhf_part = $part;
		return;
	}
}

/**
 * Recovers native $location for forums
 *
 * @global $location
 * @global $exhf_part
 * @param string $part Part is 'header' or 'footer'
 */
function exhf_recover_location($part)
{
	global $location, $exhf_part;

	if (!empty($exhf_part) && $exhf_part == $part)
	{
		$location = 'Forums'; // see forums.php
		$exhf_part = '';
	}
}

/**
 * Returns normalized code
 *
 * @param string $code Code of category
 * @return string
 */
function exhf_normalize_code($code)
{
	$code = strtr($code, ' .', '__');
	$code = preg_replace('#[^a-zA-Z0-9\-_]#', '', $code);

	return strtolower($code);
}
?>