<?php
/*
 * @package AJAX_Chat
 * @author Sebastian Tschan
 * @copyright (c) Sebastian Tschan
 * @license GNU Affero General Public License
 * @link https://blueimp.net/ajax/
 */


define('SED_CODE', TRUE);

require('../datas/config.php');
include('../system/functions.php');

// START - common.php

/* ======== First... ======== */

if (version_compare(PHP_VERSION, '6.0.0', '<='))
{
	if (get_magic_quotes_gpc())
	{
		function sed_disable_mqgpc(&$value, $key)
		{
			$value = stripslashes($value);
		}
		$gpc = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
		array_walk_recursive($gpc, 'sed_disable_mqgpc');
	}
}
define('MQGPC', FALSE);
error_reporting(E_ALL ^ E_NOTICE);

/* ======== Connect to the SQL DB======== */

require_once($cfg['system_dir'].'/database.'.$cfg['sqldb'].'.php');
$sed_dbc = sed_sql_connect($cfg['mysqlhost'], $cfg['mysqluser'], $cfg['mysqlpassword'], $cfg['mysqldb']);
unset($cfg['mysqlhost'], $cfg['mysqluser'], $cfg['mysqlpassword']);

/* ======== Configuration settings (from the DB) ======== */

$sql_config = sed_sql_query("SELECT config_owner, config_cat, config_name, config_value FROM $db_config");

while ($row = sed_sql_fetcharray($sql_config))
{
	if ($row['config_owner']=='core')
	{ $cfg[$row['config_name']] = $row['config_value']; }
	else
	{ $cfg['plugin'][$row['config_cat']][$row['config_name']] = $row['config_value']; }
}

// Mbstring options
mb_internal_encoding($cfg['charset']); 

/* ======== Extra settings (the other presets are in functions.php) ======== */

$sys['day'] = @date('Y-m-d');
$sys['now'] = time();
$sys['now_offset'] = $sys['now'] - $cfg['servertimezone']*3600;
$online_timedout = $sys['now'] - $cfg['timedout'];
$cfg['doctype'] = sed_setdoctype($cfg['doctypeid']);
$cfg['css'] = $cfg['defaultskin'];
if($cfg['clustermode'])
{
	if(isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) $usr['ip'] = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
	elseif(isset($_SERVER['HTTP_X_REAL_IP'])) $usr['ip'] = $_SERVER['HTTP_X_REAL_IP'];
	elseif(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) $usr['ip'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
	else $usr['ip'] = $_SERVER['REMOTE_ADDR'];
}
else
{
	$usr['ip'] = $_SERVER['REMOTE_ADDR'];
}
$sys['unique'] = sed_unique(16);

// Getting the server-relative path
$url = parse_url($cfg['mainurl']);
$sys['secure'] = $url['scheme'] == 'https' ? true : false;
$sys['site_uri'] = $url['path'];
$sys['domain'] = preg_replace('#^www\.#', '', $url['host']);
if(empty($cfg['cookiedomain'])) $cfg['cookiedomain'] = $sys['domain'];
if($sys['site_uri'][mb_strlen($sys['site_uri']) - 1] != '/') $sys['site_uri'] .= '/';
define('SED_SITE_URI', $sys['site_uri']);
if(empty($cfg['cookiepath'])) $cfg['cookiepath'] = $sys['site_uri'];
// Absolute site url
$sys['host'] = (mb_stripos($_SERVER['HTTP_HOST'], $sys['domain']) !== false) ? $_SERVER['HTTP_HOST'] : $sys['domain'];
$sys['abs_url'] = $url['scheme'] . '://' . $sys['host']. $sys['site_uri'];
define('SED_ABSOLUTE_URL', $sys['abs_url']);

$sys['uri_curr'] = (mb_stripos($_SERVER['REQUEST_URI'], $sys['site_uri']) === 0) ? mb_substr($_SERVER['REQUEST_URI'], mb_strlen($sys['site_uri'])) : ltrim($_SERVER['REQUEST_URI'], '/');
$sys['uri_redir'] = base64_encode($sys['uri_curr']);
$sys['url_redirect'] = 'redirect='.$sys['uri_redir'];
$redirect = sed_import('redirect','G','SLU');
$out['uri'] = str_replace('&', '&amp;', $sys['uri_curr']);

define('SED_AJAX', !empty($_SERVER['HTTP_X_REQUESTED_WITH'])); 

/* ======== Check the banlist ======== */

$userip = explode('.', $usr['ip']);
$ipmasks = "('".$userip[0].".".$userip[1].".".$userip[2].".".$userip[3]."','".$userip[0].".".$userip[1].".".$userip[2].".*','".$userip[0].".".$userip[1].".*.*','".$userip[0].".*.*.*')";

$sql = sed_sql_query("SELECT banlist_id, banlist_ip, banlist_reason, banlist_expire FROM $db_banlist WHERE banlist_ip IN ".$ipmasks);

If (sed_sql_numrows($sql)>0)
	{
	$row=sed_sql_fetcharray($sql);
	if ($sys['now']>$row['banlist_expire'] && $row['banlist_expire']>0)
		{
		$sql = sed_sql_query("DELETE FROM $db_banlist WHERE banlist_id='".$row['banlist_id']."' LIMIT 1");
		}
	else
		{
		$disp = "Your IP is banned.<br />Reason: ".$row['banlist_reason']."<br />Until: ";
		$disp .= ($row['banlist_expire']>0) ? @date($cfg['dateformat'], $row['banlist_expire'])." GMT" : "Never expire.";
		sed_diefatal($disp);
		}
	}

/* ======== Groups ======== */

if (!$sed_groups )
	{
	$sql = sed_sql_query("SELECT * FROM $db_groups WHERE grp_disabled=0 ORDER BY grp_level DESC");

	if (sed_sql_numrows($sql)>0)
		{
		while ($row = sed_sql_fetcharray($sql))
			{
			$sed_groups[$row['grp_id']] = array (
				'id' => $row['grp_id'],
				'alias' => $row['grp_alias'],
				'level' => $row['grp_level'],
   				'disabled' => $row['grp_disabled'],
   				'hidden' => $row['grp_hidden'],
				'state' => $row['grp_state'],
				'title' => sed_cc($row['grp_title']),
				'desc' => sed_cc($row['grp_desc']),
				'icon' => $row['grp_icon'],
				'pfs_maxfile' => $row['grp_pfs_maxfile'],
				'pfs_maxtotal' => $row['grp_pfs_maxtotal'],
				'ownerid' => $row['grp_ownerid']
					);
			}
		}
	else
		{ sed_diefatal('No groups found.'); }

	sed_cache_store('sed_groups',$sed_groups,3600);
	}

/* ======== User/Guest ======== */

$usr['id'] = 0;
$usr['sessionid'] = '';
$usr['name'] = '';
$usr['level'] = 0;
$usr['lastvisit'] = 30000000000;
$usr['lastlog'] = 0;
$usr['timezone'] = $cfg['defaulttimezone'];
$usr['newpm'] = 0;
$usr['messages'] = 0;

$site_id = 'ct' . substr(md5($cfg['mainurl']), 0, 10);
$sys['site_id'] = $site_id;

session_start();

if(!empty($_COOKIE[$site_id]) || !empty($_SESSION[$site_id]))
{
	$u = empty($_SESSION[$site_id]) ? base64_decode($_COOKIE[$site_id]) : base64_decode($_SESSION[$site_id]);
	$u = explode(':_:', $u);
	$u_id = (int) sed_import($u[0], 'D', 'INT');
	$u_passhash = sed_import($u[1], 'D', 'ALP');
	if($u_id > 0)

	{ 
		$sql = sed_sql_query("SELECT * FROM $db_users WHERE user_id = ".$u_id."");

		if($row = sed_sql_fetcharray($sql))
		{  
			$passhash = md5($row['user_password'].$row['user_hashsalt']);
			if(($u_passhash == $passhash || ($sys['now_offset'] - $_SESSION['saltstamp'] < 60 && $u_passhash == $_SESSION['oldhash'])) && $row['user_maingrp'] > 3
				&& ($cfg['ipcheck']==FALSE || $row['user_lastip'] == $usr['ip']))
			{ 
				$usr['id'] = (int) $row['user_id'];
				$usr['name'] = $row['user_name'];
				$usr['maingrp'] = $row['user_maingrp'];
				$usr['lastvisit'] = $row['user_lastvisit'];
				$usr['lastlog'] = $row['user_lastlog'];
				$usr['timezone'] = $row['user_timezone'];
				$usr['skin'] = ($cfg['forcedefaultskin']) ? $cfg['defaultskin'] : $row['user_skin'];
				$usr['theme'] = $row['user_theme'];
				$usr['lang'] = ($cfg['forcedefaultlang']) ? $cfg['defaultlang'] : $row['user_lang'];
				$usr['newpm'] = $row['user_newpm'];
				$usr['auth'] = unserialize($row['user_auth']);
				$usr['level'] = $sed_groups[$usr['maingrp']]['level'];
				$usr['profile'] = $row;

				if (!isset($_SESSION['cot_user_id']))
				{
					$_SESSION['cot_user_id'] = $usr['id'];
				}

				if ($usr['lastlog'] + $cfg['timedout'] < $sys['now_offset'])
				{
					$sys['comingback']= TRUE;
					if ($usr['lastlog'] > $usr['lastvisit'])
					{
						$usr['lastvisit'] = $usr['lastlog'];
						$update_lastvisit = ", user_lastvisit = " . $usr['lastvisit'];
					}
				}


				if (!$cfg['authcache'] || empty($row['user_auth']))
				{
					$usr['auth'] = sed_auth_build($usr['id'], $usr['maingrp']);
					if($cfg['authcache']) $update_auth = ", user_auth='".serialize($usr['auth'])."'";
				}

				if(empty($_SESSION['saltstamp']) || $sys['now_offset'] - $_SESSION['saltstamp'] > 60)
				{
					$_SESSION['saltstamp'] = $sys['now_offset'];
					$_SESSION['oldhash'] = $u_passhash;
					$hashsalt = sed_unique(16);
					$passhash = md5($row['user_password'].$hashsalt);
					$u = base64_encode($usr['id'].':_:'.$passhash);
					if(empty($_SESSION[$site_id]))
					{
						sed_setcookie($site_id, $u, time()+$cfg['cookielifetime'], $cfg['cookiepath'],
							$cfg['cookiedomain'], $sys['secure'], true);
					}
					else
					{
						$_SESSION[$site_id] = $u;
					}
					$update_hashsalt = ", user_hashsalt = '$hashsalt'";
				}

				if(empty($_COOKIE['sourcekey']))
				{
					$sys['xk'] = mb_strtoupper(sed_unique(8));
					$update_sid = ", user_sid = '{$sys['xk']}'";
					sed_setcookie('sourcekey', $sys['xk'], time()+$cfg['cookielifetime'], $cfg['cookiepath'],
						$cfg['cookiedomain'], $sys['secure'], true);
				}
				else
				{
					$sys['xk'] = $_COOKIE['sourcekey'];
					$update_sid = '';
				}

				sed_sql_query("UPDATE $db_users
					SET user_lastlog = {$sys['now_offset']} $update_lastvisit $update_sid $update_hashsalt $update_auth
					WHERE user_id='{$usr['id']}'");

				unset($u, $passhash, $update_auth, $update_hashsalt, $update_lastvisit, $update_sid);
			}
		}
	}
	else
	{
		$usr['skin'] = sed_import($u[0], 'D', 'ALP');
		$usr['theme'] = sed_import($u[1], 'D', 'ALP');
		$usr['lang'] = sed_import($u[2], 'D', 'ALP');
	}
}

if($usr['id']==0)
{
	$usr['auth'] = sed_auth_build(0);
	$usr['skin'] = empty($usr['skin']) ? $cfg['defaultskin'] : $usr['skin'];
	$usr['theme'] = empty($usr['theme']) ? $cfg['defaulttheme'] : $usr['theme'];
	$usr['lang'] = empty($usr['lang']) ? $cfg['defaultlang'] : $usr['lang'];
	$sys['xk'] = mb_strtoupper(dechex(crc32($sys['abs_url']))); // Site related key for guests
} 

/* ======== Language ======== */
$usr['lang'] = (empty($_COOKIE['deflang'])) ? $cfg['defaultlang'] : $_COOKIE['deflang'];


// END - common.php

?>