<?php
/*
 * @package AJAX_Chat
 * @author Sebastian Tschan
 * @copyright (c) Sebastian Tschan
 * @license GNU Affero General Public License
 * @link https://blueimp.net/ajax/
 */
class CustomAJAXChat extends AJAXChat {
	
	function getLangCode() {

		global $usr;
		
		if($usr['id']>0) {
			$langCode = $usr['lang'];
		} else {
			// Get the langCode from request or cookie:
			$langCodeCookie = isset($_COOKIE[$this->getConfig('sessionName').'_lang']) ? $_COOKIE[$this->getConfig('sessionName').'_lang'] : null;
			$langCode = $this->getRequestVar('lang') ? $this->getRequestVar('lang') : $langCodeCookie;
		}
		
		// Check if the langCode is valid:
		if(!in_array($langCode, $this->getConfig('langAvailable'))) {
			// Determine the user language:
			$language = new AJAXChatLanguage($this->getConfig('langAvailable'), $this->getConfig('langDefault'));
			$langCode = $language->getLangCode();
		}
		return $langCode;
	}

	// Initialize custom request variables:
	function initCustomRequestVars() {
		global $usr;

		// Auto-login phpBB users:
		if(!$this->getRequestVar('logout') && $usr['id']>0) {
			$this->setRequestVar('login', true);
		}
	}

	// Replace custom template tags:
	function replaceCustomTemplateTags($tag, $tagContent) {
		global $usr;

		switch($tag) {
			case 'REDIRECT_URL':
				if($usr['id']==0) {
					return '';
				} else {
					return $this->htmlEncode($this->getRequestVar('view') == 'logs' ? $this->getChatURL().'?view=logs' : $this->getChatURL());
				}
			default:
				return null;
		}
	}


	// Returns an associative array containing userName, userID and userRole
	// Returns null if login is invalid
	function getValidLoginUserData() {
		
		global $usr;
		
		$userName = $this->getRequestVar('userName');
		
		if ($usr['id']>0 && !$userName) {
					$userData = array();
					$userData['userID'] = $usr['id'];
					$userData['userName'] = $this->trimUserName($usr['name']);
					
					if ($usr['level']==99){ $userData['userRole'] = AJAX_CHAT_ADMIN;}
					elseif (49 < $usr['level']) { $userData['userRole'] = AJAX_CHAT_MODERATOR;}
					else {$userData['userRole'] = AJAX_CHAT_USER;}

					return $userData;
		} else { 
			// Guest users:
			
			return $this->getGuestUser();
		}		
	}


}
?>